#ifndef INTERFACE_H_INCLUDED
#define INTERFACE_H_INCLUDED

#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>

#define SAISIE_MAX 255
#define TITRE "Kaaptur - Client"

#define BITSPERPIXEL 32
#define POLICE_TEXTE "papyrus.ttf"
#define POLICE_TAILLE_NORMALE 18
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    #define RMASK  0xff000000
    #define GMASK  0x00ff0000
    #define BMASK  0x0000ff00
    #define AMASK  0x000000ff
#else
    #define RMASK  0x000000ff
    #define GMASK  0x0000ff00
    #define BMASK  0x00ff0000
    #define AMASK  0xff000000
#endif

#define TILE_TAILLE 32
#define SCROLL_BORDURE 64

#include "typedef.h"
#include "map.h"
#include "jeu.h"
#include "reseau.h"

// Fonctions d'initialisation / libration
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur,long plein_ecran); // Initialise la SDL
void initialiser_interface(t_interface* interface,t_partie* jeu); // Initialise l'interface et les elements du GUI
void liberer_interface(t_interface* interface); // Supprime les donnes de l'interface
void liberer_affichage(SDL_Surface* fenetre); // Libre la fenetre, et quitte les librairies initialises

// Fonctions d'affichage / Rafraichissement
void afficher_interface(t_interface* interface,t_partie* jeu); // Affiche l'interface
void afficher_message(t_interface* interface, char *txt, long rouge, long vert, long bleu); // Affiche un message dans la fenetre de chat

// Fonctions de gestion des venements GUI
long obtenir_element(t_interface *interface,enum gui_flag flag); // Rcupre le dernier element portant le flag prcis
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible); // Affiche / Masque un groupe d'elements en fonction de visible
void actualiser_gui(long element,t_interface* interface,t_partie* jeu); // Actualise les elements et les donnes avant affichage
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_partie* jeu, t_serveur *serv); // Effectuer l'action d'un flag
void scroller_ecran(t_interface* interface,t_map* map); // Scrolle l'ecran en fonction du curseur / Touche enfonce
SDL_Rect obtenir_curseur_minimap(t_interface* interface,t_map *map);
long obtenir_fps(long incrementer); // Obtient le nombre d'Images par Secondes (et incrmente le nombre de rafraichissement)

// Fonctions Diverses
long comparer_commande(char *cmd, char *str); // Verifie si la chaine de caractre correspond  la commande passe
Uint32 GetPixel(SDL_Surface* surface, long x, long y);  // Renvoie le pixel d'une surface
#endif // INTERFACE_H_INCLUDED
